<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<div class="container py-5">
    <div class="row">
        <!-- Main Content -->
        <div class="col-lg-8 mb-4">
            <div class="card shadow-sm border-0">
                <?php if (!empty($workshop->featured_image)): ?>
                    <img src="<?php echo base_url('uploads/workshops/' . $workshop->featured_image); ?>" 
                         class="card-img-top" 
                         alt="<?php echo htmlspecialchars($workshop->title); ?>"
                         style="max-height: 500px; object-fit: cover;">
                <?php endif; ?>
                
                <div class="card-body p-4 p-md-5">
                    <!-- Status Badge -->
                    <div class="mb-3">
                        <?php
                        $status_badges = [
                            'upcoming' => '<span class="badge bg-warning text-dark">Upcoming</span>',
                            'ongoing' => '<span class="badge bg-success">Ongoing</span>',
                            'completed' => '<span class="badge bg-info">Completed</span>',
                            'cancelled' => '<span class="badge bg-danger">Cancelled</span>'
                        ];
                        echo $status_badges[$workshop->status] ?? '';
                        ?>
                        <?php if ($workshop->is_featured): ?>
                            <span class="badge bg-primary ms-2">
                                <i class="fas fa-star"></i> Featured
                            </span>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Title -->
                    <h1 class="fw-bold mb-3"><?php echo htmlspecialchars($workshop->title); ?></h1>
                    
                    <!-- Description -->
                    <p class="lead"><?php echo htmlspecialchars($workshop->description); ?></p>
                    
                    <!-- Workshop Details Grid -->
                    <div class="row g-3 my-4">
                        <?php if (!empty($workshop->duration)): ?>
                            <div class="col-md-6">
                                <div class="p-3 bg-light rounded">
                                    <i class="far fa-clock text-primary fa-2x mb-2"></i>
                                    <h6 class="fw-bold mb-1">Duration</h6>
                                    <p class="mb-0"><?php echo htmlspecialchars($workshop->duration); ?></p>
                                </div>
                            </div>
                        <?php endif; ?>
                        
                        <?php if (!empty($workshop->location)): ?>
                            <div class="col-md-6">
                                <div class="p-3 bg-light rounded">
                                    <i class="fas fa-map-marker-alt text-primary fa-2x mb-2"></i>
                                    <h6 class="fw-bold mb-1">Location</h6>
                                    <p class="mb-0"><?php echo htmlspecialchars($workshop->location); ?></p>
                                </div>
                            </div>
                        <?php endif; ?>
                        
                        <?php if (!empty($workshop->capacity)): ?>
                            <div class="col-md-6">
                                <div class="p-3 bg-light rounded">
                                    <i class="fas fa-users text-primary fa-2x mb-2"></i>
                                    <h6 class="fw-bold mb-1">Capacity</h6>
                                    <p class="mb-0"><?php echo number_format($workshop->capacity); ?> participants</p>
                                </div>
                            </div>
                        <?php endif; ?>
                        
                        <?php if (!empty($workshop->facilitator)): ?>
                            <div class="col-md-6">
                                <div class="p-3 bg-light rounded">
                                    <i class="fas fa-user-tie text-primary fa-2x mb-2"></i>
                                    <h6 class="fw-bold mb-1">Facilitator</h6>
                                    <p class="mb-0"><?php echo htmlspecialchars($workshop->facilitator); ?></p>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Full Description -->
                    <?php if (!empty($workshop->full_description)): ?>
                        <div class="mt-4">
                            <h3 class="fw-bold mb-3">About This Workshop</h3>
                            <div class="workshop-content">
                                <?php echo nl2br(htmlspecialchars($workshop->full_description)); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <!-- Objectives -->
                    <?php if (!empty($workshop->objectives)): ?>
                        <div class="mt-4">
                            <h3 class="fw-bold mb-3">Learning Objectives</h3>
                            <div class="workshop-content">
                                <?php echo nl2br(htmlspecialchars($workshop->objectives)); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <!-- Target Audience -->
                    <?php if (!empty($workshop->target_audience)): ?>
                        <div class="mt-4">
                            <h3 class="fw-bold mb-3">Who Should Attend</h3>
                            <p><?php echo htmlspecialchars($workshop->target_audience); ?></p>
                        </div>
                    <?php endif; ?>
                    
                    <!-- Requirements -->
                    <?php if (!empty($workshop->requirements)): ?>
                        <div class="mt-4">
                            <h3 class="fw-bold mb-3">Requirements</h3>
                            <div class="workshop-content">
                                <?php echo nl2br(htmlspecialchars($workshop->requirements)); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <!-- Schedule -->
                    <?php if (!empty($workshop->schedule)): ?>
                        <div class="mt-4">
                            <h3 class="fw-bold mb-3">Schedule</h3>
                            <div class="workshop-content">
                                <?php echo nl2br(htmlspecialchars($workshop->schedule)); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            
            <!-- Related Workshops -->
            <?php if (!empty($related_workshops)): ?>
                <div class="mt-5">
                    <h3 class="fw-bold mb-4">Related Workshops</h3>
                    <div class="row">
                        <?php foreach ($related_workshops as $related): ?>
                            <div class="col-md-4 mb-3">
                                <div class="card h-100 shadow-sm border-0">
                                    <a href="<?php echo base_url('workshops/view/' . $related->slug); ?>">
                                        <?php if (!empty($related->featured_image)): ?>
                                            <img src="<?php echo base_url('uploads/workshops/' . $related->featured_image); ?>" 
                                                 class="card-img-top" 
                                                 alt="<?php echo htmlspecialchars($related->title); ?>"
                                                 style="height: 150px; object-fit: cover;">
                                        <?php endif; ?>
                                    </a>
                                    <div class="card-body">
                                        <h6 class="card-title">
                                            <a href="<?php echo base_url('workshops/view/' . $related->slug); ?>" 
                                               class="text-decoration-none text-dark">
                                                <?php echo htmlspecialchars(character_limiter($related->title, 50)); ?>
                                            </a>
                                        </h6>
                                        <small class="text-muted">
                                            <?php echo htmlspecialchars($related->duration); ?>
                                        </small>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        
        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Back Button -->
            <div class="card shadow-sm border-0 mb-4">
                <div class="card-body">
                    <a href="<?php echo base_url('workshops'); ?>" class="btn btn-outline-primary w-100">
                        <i class="fas fa-arrow-left"></i> Back to Workshops
                    </a>
                </div>
            </div>
            
            <!-- Call to Action -->
            <div class="card shadow-sm border-0 mb-4" style="background: linear-gradient(135deg, #f26124, #8105bf);">
                <div class="card-body text-white text-center p-4">
                    <h5 class="fw-bold mb-3">Interested in Our Programs?</h5>
                    <p class="mb-3">Get in touch with us for more information</p>
                    <a href="<?php echo base_url('contact'); ?>" class="btn btn-light w-100 mb-2">
                        <i class="fas fa-envelope"></i> Contact Us
                    </a>
                    <a href="<?php echo base_url('consultation'); ?>" class="btn btn-outline-light w-100">
                        <i class="fas fa-calendar-check"></i> Book Consultation
                    </a>
                </div>
            </div>
            
            <!-- Quick Links -->
            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <h5 class="fw-bold mb-3">Explore More</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2">
                            <a href="<?php echo base_url('workshops'); ?>" class="text-decoration-none">
                                <i class="fas fa-chalkboard-teacher text-primary"></i> All Workshops
                            </a>
                        </li>
                        <li class="mb-2">
                            <a href="<?php echo base_url('volunteer/apply'); ?>" class="text-decoration-none">
                                <i class="fas fa-hands-helping text-primary"></i> Become a Volunteer
                            </a>
                        </li>
                        <li class="mb-2">
                            <a href="<?php echo base_url('blog'); ?>" class="text-decoration-none">
                                <i class="fas fa-newspaper text-primary"></i> Our Blog
                            </a>
                        </li>
                        <li class="mb-0">
                            <a href="<?php echo base_url('donate'); ?>" class="text-decoration-none">
                                <i class="fas fa-heart text-primary"></i> Support Us
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.workshop-content {
    line-height: 1.8;
}

.workshop-content ul, .workshop-content ol {
    padding-left: 2rem;
}
</style>